<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjectsToStepsRestApi\Client;

use Doctrine\Common\Collections\ArrayCollection;
use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use ExportObjectsToStepsRestApi\Client\Manager;
use ExportObjectsToStepsRestApi\Config\Client;
use ExportObjectsToStepsRestApi\Config\PluginConfig;
use ExportObjectsToStepsRestApi\Config\Service;

/**
 * Class TestManager
 *
 * @package Tests\ExportObjects\Client
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * setUp
     */
    public function setUp()
    {
        $pluginConfig = new PluginConfig();
        $clientCollection = new ArrayCollection();

        $client = new Client(['id' => 42, 'active' => true]);
        $clientCollection->add($client);

        $client = new Client(['id' => 56, 'active' => false]);
        $clientCollection->add($client);

        $serviceCollection = new ArrayCollection();

        $service = new Service(['name' => 'updateNameXml', 'url' => 'http://localhost/update.xml']);
        $serviceCollection->add($service);

        $clientCollection->first()->setServices($serviceCollection);

        $pluginConfig->setClients($clientCollection);

        $this->apiManager = $this
            ->getMockBuilder(ApiManager::class)
            ->getMock();

        $this->apiManager
            ->method('pluginConfig')
            ->will($this->returnValue($pluginConfig));
    }

    /**
     * testManagerActive
     */
    public function testManagerActive()
    {
        $clientManager = new Manager($this->apiManager);

        $clients = $clientManager->active();
        $this->assertCount(1, $clients);
        $this->assertEquals(42, $clients[0]->getId());
    }

    /**
     * testManagerServices
     *
     * @throws \ExportObjects\Config\InvalidConfigException
     */
    public function testManagerServices()
    {
        $clientManager = new Manager($this->apiManager);
        $this->assertInstanceOf(Service::class, $clientManager->service($clientManager->active(42)->first(), 'updateNameXml'));
    }

    /**
     * testManagerServicesException
     *
     * @throws \ExportObjectsToStepsRestApi\Config\InvalidConfigException
     * @expectedException \ExportObjectsToStepsRestApi\Config\InvalidConfigException
     */
    public function testManagerServicesException()
    {
        $clientManager = new Manager($this->apiManager);
        $clientManager->service($clientManager->active(42)->first(), 'updateNameNotValid');
    }
}
