<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjectsToStepsRestApi\Config;

use ExportObjectsToStepsRestApi\Config\Language;
use JMS\Serializer\SerializerBuilder;
use ExportObjectsToStepsRestApi\Config\Client;
use Doctrine\Common\Collections\ArrayCollection;
use ExportObjectsToStepsRestApi\Config\Service;

/**
 * Class ConfigTest
 * @package Tests\ExportObjectsToStepsRestApi\Config
 */
class ConfigTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Id":"id","Active":true,"ApiUserName":"UnitTestUser","ApiKey":"UnitTestKey","Services":[{"Name":"updateNameXml","Url":"http:\/\/localhost\/update.xml","Method":"UNIT_TEST","ApiVersion":99}],"Languages":[{"Id":"de_unit_test"}]}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {
        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $client = new Client([
            'id' => 'id',
            'active' => true,
            'apiUserName' => 'UnitTestUser',
            'apiKey' => 'UnitTestKey',
        ]);

        $serviceCollection = new ArrayCollection();

        $service = new Service([
            'name' => 'updateNameXml',
            'url' => 'http://localhost/update.xml',
            'method' => 'UNIT_TEST',
            'apiVersion' => 99,
        ]);

        $serviceCollection->add($service);
        $client->setServices($serviceCollection);

        $languagesCollection = new ArrayCollection();
        $language = new Language(['id' => 'de_unit_test']);
        $languagesCollection->add($language);

        $client->setLanguages($languagesCollection);

        $this->assertEquals($this->jsonString, $this->serializer->serialize($client, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {
        /**
         * @var Client $client
         */
        $client = $this->serializer->deserialize($this->jsonString, Client::class, 'json');

        $this->assertSame('id', $client->getId());
        $this->assertTrue($client->isActive());
        $this->assertSame('UnitTestKey', $client->getApiKey());
        $this->assertSame('UnitTestUser', $client->getApiUserName());

        $this->assertInstanceOf(Service::class, $client->getServices()->first());
        $this->assertSame('updateNameXml', $client->getServices()[0]->getName());
        $this->assertSame('http://localhost/update.xml', $client->getServices()[0]->getUrl());
        $this->assertSame(99, $client->getServices()[0]->getApiVersion());
        $this->assertSame('UNIT_TEST', $client->getServices()[0]->getMethod());

        $this->assertInstanceOf(Language::class, $client->getLanguages()->first());
        $this->assertSame('de_unit_test', $client->getLanguages()[0]->getId());
    }
}
