<?php

/**
 * ExportObjectsToRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjectsToStepsRestApi\Services\Product\Delete;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use ExportObjectsToStepsRestApi\Config\Client;
use ExportObjectsToStepsRestApi\Config\Service;
use ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue\Factory as RequestQueueFactory;
use ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue\Queue;
use ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue\Sender;
use Pimcore\Model\Object\Product;

/**
 * Class QueueTest
 * @package Tests\ExportObjectsToStepsRestApi\Services\Product\Delete
 */
class QueueTest extends \PHPUnit_Framework_TestCase
{
    public function testExecute()
    {
        $apiManager = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->getMock();

        $senderMock = $this->getMockBuilder(Sender::class)
            ->disableOriginalConstructor()
            ->setMethods(['send'])
            ->getMock();
        $senderMock->expects($this->once())
            ->method('send')
            ->willReturn('');

        $requestQueue = new Queue(new RequestQueueFactory($apiManager), $senderMock);

        $client = new Client([
            'apiUserName' => 'api_unit_test_user',
            'apiKey' => 'api_unit_test_key',
        ]);
        $service = new Service([
            'url' => 'https://steps-rest-ws/api/products/{productId}.json',
            'method' => 'UNIT_TEST',
            'apiVersion' => 1,
        ]);

        $this->assertFalse($requestQueue->hasItems());
        $requestQueue->addClientRequest($client, $service, new Product());
        $this->assertTrue($requestQueue->hasItems());

        $requestQueue->execute();
    }
}
