<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Api;

use ExportObjectsToStepsRestApi\Database\Manager as DatabaseManager;
use ExportObjectsToStepsRestApi\Entity\Factory as EntityFactory;
use ExportObjectsToStepsRestApi\EventListener\Manager as EventListenerManager;
use ExportObjectsToStepsRestApi\Mapper\Factory as MapperFactory;
use ExportObjectsToStepsRestApi\Services\Factory as ServicesFactory;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Pimcore\Log\ApplicationLogger as Logger;
use ExportObjectsToStepsRestApi\Client\Manager as ClientManager;
use ExportObjectsToStepsRestApi\Config\PluginConfig;
use ExportObjectsToStepsRestApi\Webservice\Manager as WebserviceManager;
use ExportObjectsToStepsRestApi\Pimcore\Manager as PimcoreManager;

/**
 * Api-Manager
 *
 * @package ExportObjects\Api
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{
    /**
     * @var array
     */
    private $facSetter = array();

    /**
     * @return EventListenerManager
     */
    public function eventListener()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new EventListenerManager($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ServicesFactory
     */
    public function services()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ServicesFactory($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new WebserviceManager($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Logger
     */
    public function logger()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = Logger::getInstance("ExportObjectsToStepsRestApi", true);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new MapperFactory($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ClientManager
     */
    public function clients()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ClientManager($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = $this->serializer()->deserialize(
                file_get_contents(__DIR__ . '/../../../config.xml'), 'ExportObjectsToStepsRestApi\Config\PluginConfig', 'xml'
            );
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = SerializerBuilder::create()->build();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new PimcoreManager($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return DatabaseManager
     */
    public function database()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new DatabaseManager($this);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return EntityFactory
     */
    public function entityFactory()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new EntityFactory($this);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
