<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Config;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Client
 *
 * @package ExportObjectsToStepsRestApi\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Client")
 */
class Client
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("boolean")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("ApiUserName")
     * @Serializer\Type("string")
     * @var string
     */
    private $apiUserName;

    /**
     * @Serializer\SerializedName("ApiKey")
     * @Serializer\Type("string")
     * @var string
     */
    private $apiKey;

    /**
     * @Serializer\SerializedName("Services")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Config\Service>")
     * @Serializer\XmlList(entry="Service")
     * @var ArrayCollection
     */
    private $services;

    /**
     * @Serializer\SerializedName("Languages")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Config\Language>")
     * @Serializer\XmlList(entry="Language")
     * @var ArrayCollection
     */
    private $languages;

    /**
     * @param array $data
     */
    public function __construct($data = array())
    {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @return string
     */
    public function getApiUserName()
    {
        return $this->apiUserName;
    }

    /**
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }

    /**
     * @param Service[]|ArrayCollection $services
     */
    public function setServices($services)
    {
        $this->services = $services;
    }

    /**
     * @return Service[]|ArrayCollection
     */
    public function getServices()
    {
        return $this->services;
    }

    /**
     * @param Language[]|ArrayCollection $languages
     */
    public function setLanguages($languages)
    {
        $this->languages = $languages;
    }

    /**
     * @return Language[]|ArrayCollection
     */
    public function getLanguages()
    {
        return $this->languages;
    }
}
