<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Config;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Config
 *
 * @package ExportObjectsToStepsRestApi\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("ExportObjectsToStepsRestApi")
 */
class PluginConfig
{
    /**
     * @Serializer\SerializedName("Clients")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Config\Client>")
     * @Serializer\XmlList(inline = false, entry = "Client")
     * @var Client[]|ArrayCollection
     */
    private $clients;

    /**
     * @return Client[]|ArrayCollection
     */
    public function getClients()
    {
        return $this->clients;
    }

    /**
     * @param $clients Client[]|ArrayCollection
     */
    public function setClients($clients)
    {
        $this->clients = $clients;
    }
}
