<?php

/**
 * Life-Style PimCore Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Database;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\Resource\Mysql as Resource;

/**
 * Manage database
 *
 * @package ExportObjectsToStepsRestApi\Database
 */
class Manager
{
    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return ProductRegister
     */
    public function productRegister()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ProductRegister($this->apiM, $this->getDatabaseConnection()));
    }

    /**
     * @return mixed|\Zend_Db_Adapter_Abstract
     */
    private function getDatabaseConnection()
    {
        return Resource::get();
    }
}