<?php

/**
 * Life-Style PimCore Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Database;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use ExportObjectsToStepsRestApi\Entity\ProductRegister as EntityProductRegister;

class ProductRegister
{
    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * @var \Zend_Db_Adapter_Abstract
     */
    private $db;

    /**
     * @param ApiManager $apiM
     * @param \Zend_Db_Adapter_Abstract $db
     */
    public function __construct(ApiManager $apiM, $db)
    {
        $this->apiM = $apiM;
        $this->db = $db;
    }

    /**
     * @param $objectId
     * @return EntityProductRegister
     */
    public function findByClientAndObjectId($clientId, $objectId)
    {
        $sql = 'SELECT * FROM ProductRegister WHERE `clientId`=? AND `objectId`=?';
        $bind = array((string) $clientId, (string) $objectId);

        if (!$row = $this->db->fetchRow($sql, $bind)) {
            return null;
        }

        return $this->apiM->entityFactory()->productRegister($row);
    }

    /**
     * @param array $data
     */
    public function addEntityFromArray($data)
    {
        if (0 < count($data)) {
            $this->db->insert('ProductRegister', $data);
        }
    }

    /**
     * @param string $clientId
     * @param string $objectId
     * @param array $data
     */
    public function saveEntity($clientId, $objectId, $data)
    {
        if (!$clientId || !$objectId || 0 >= count($data)) {
            return;
        }

        $sql = 'SELECT * FROM ProductRegister WHERE `clientId`=? AND `objectId`=?';
        $bind = array($clientId, $objectId);
        $row = $this->db->fetchRow($sql, $bind);

        if (!$row) {
            return;
        }

        $entity = $this->apiM->entityFactory()->productRegister($row);
        $this->db->update('ProductRegister', $data, array('clientId=?' => $entity->getClientId(), 'objectId=?' => $entity->getObjectId()));
    }
}