<?php

/**
 * Life-Style PimCore Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Entity;

/**
 * Class ProductRegister
 * @package ExportObjectsToStepsRestApi\Entity
 */
class ProductRegister
{
    /**
     * @var integer
     */
    private $objectId;

    /**
     * @var string
     */
    private $clientId;

    /**
     * @var bool
     */
    private $published;

    /**
     * @var bool
     */
    private $deleted;

    /**
     * @var \DateTime
     */
    private $deletedAt;

    /**
     * ProductVariant constructor.
     * @param array $data Initial data
     */
    public function __construct($data = array())
    {
        foreach ($data as $key => $value) {
            $method = 'set' . ucfirst($key);
            if (is_callable(array($this, $method))) {
                $this->$method($value);
            }
        }
    }

    /**
     * @return int
     */
    public function getObjectId()
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     * @return ProductRegister
     */
    public function setObjectId($objectId)
    {
        $this->objectId = $objectId;
        return $this;
    }

    /**
     * @return string
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * @param string $clientId
     * @return ProductRegister
     */
    public function setClientId($clientId)
    {
        $this->clientId = $clientId;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPublished()
    {
        return $this->published;
    }

    /**
     * @param bool $published
     * @return ProductRegister
     */
    public function setPublished($published)
    {
        $this->published = $published;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param bool $deleted
     * @return ProductRegister
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
     * @param \DateTime $deletedAt
     * @return ProductRegister
     */
    public function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
        return $this;
    }

    /**
     * @return array
     */
    public function toDbArray()
    {
        return [
            'published' => $this->isPublished(),
            'deleted' => $this->isDeleted(),
            'deletedAt' => $this->getDeletedAt(),
        ];
    }
}
