<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\EventListener;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\Model\Object\Product;

/**
 * Event-Listener Add-Object
 * @package ExportObjectsToStepsRestApi\EventListener
 */
class StepsBoxAdd implements ListenerInterface
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Attach event listener
     */
    public function init()
    {
        \Pimcore::getEventManager()->attach("stepsbox.add", array($this, 'add'));
    }

    /**
     * Update objects
     *
     * @param \Zend_EventManager_Event $event
     * @return \Zend_EventManager_Event
     */
    public function add(\Zend_EventManager_Event $event)
    {
        if ($this->hasSubscribed($event)) {
            $this->apiM->logger()->debug('Triggered event stepsbox.add object');
            $this->apiM->services()->product()->add()->handler()->init($event->getTarget());
        }

        return $event;
    }

    /**
     * @param \Zend_EventManager_Event $event
     *
     * @return bool
     */
    private function hasSubscribed(\Zend_EventManager_Event $event)
    {
        return true;
    }
}
