<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Mapper;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\Model\Object\Product as ObjectProduct;

/**
 * Factory for Mapper
 *
 * @package ExportObjectsToStepsRestApi\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Factory
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Create new product mapper
     *
     * @param ObjectProduct $objectProduct
     * @return Product
     */
    public function product(ObjectProduct $objectProduct)
    {
        return new Product($this->apiM, $objectProduct);
    }
}
