<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Mapper;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;

/**
 * Class Object
 * @package ExportObjectsToStepsRestApi\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
abstract class Object extends Base
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param string $language
     * @return array
     */
    public function getLocalizedValues($language)
    {
        $items = $this->getObject()->getLocalizedfields()->getItems();

        // No values for selected language
        if (!isset($items[$language])) {
            $this->apiM->logger()->info(sprintf('No localized fields for language %s in object %d', $language, $this->getObject()->getId()));

            return [];
        }

        // Get localized values
        $values = [];
        foreach (array_keys($items[$language]) as $name) {
            null !== ($value = $this->getObject()->getLocalizedfields()->getLocalizedValue($name, $language)) ? $values[$name] = $value : null;
        }

        return $values;
    }

    /**
     * @return array
     */
    public function getValues()
    {
        $values = [];
        foreach ($this->getObjectProperties() as $property) {
            $method = 'get' . ucfirst($property);
            null !== ($value = $this->getObject()->$method()) ? $values[$property] = $value : null;
        }

        return $values;
    }

    /**
     * @param string $property
     * @return mixed
     */
    public function getValue($property)
    {
        $method = 'get' . ucfirst($property);
        return $this->getObject()->$method();
    }
}
