<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Mapper;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\Model\Object\Product as ObjectProduct;

/**
 * Class Product
 * @package ExportObjectsToStepsRestApi\Mapper
 */
class Product extends Object
{
    /**
     * @var ObjectProduct
     */
    private $objectProduct;

    /**
     * Product constructor.
     * @param ApiManager $apiM
     * @param ObjectProduct $objectProduct
     */
    public function __construct(ApiManager $apiM, ObjectProduct $objectProduct)
    {
        parent::__construct($apiM);
        $this->objectProduct = $objectProduct;
    }

    /**
     * @return ObjectProduct
     */
    public function getObject()
    {
        return $this->objectProduct;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {
        return preg_match('/^datenblatt/', $property) || 'localizedfields' == $property;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return mixed
     */
    public function mapNameId($name)
    {
        return preg_replace('/^datenblatt(multi)?/i', '', $name);
    }
}
