<?php

namespace ExportObjectsToStepsRestApi;

use Doctrine\Common\Annotations\AnnotationRegistry;
use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\API\Plugin as PluginLib;

class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    public function init()
    {
        parent::init();

        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');

        $apiM = new ApiManager();
        $apiM->eventListener()->init();
    }

    /**
     * @return bool
     */
    public static function needsReloadAfterInstall()
    {
        return false;
    }

    /**
     * @return string
     */
    public static function install()
    {
        $path = self::getInstallPath();

        if (!is_dir($path)) {
            mkdir($path);
        }

        if (self::isInstalled()) {
            return "ExportObjectsToStepsRestApi Plugin successfully installed.";
        } else {
            return "ExportObjectsToStepsRestApi Plugin could not be installed.";
        }
    }

    /**
     * @return string
     */
    public static function uninstall()
    {
        rmdir(self::getInstallPath());

        if (!self::isInstalled()) {
            return "ExportObjectsToStepsRestApi Plugin successfully uninstalled.";
        } else {
            return "ExportObjectsToStepsRestApi Plugin could not be uninstalled.";
        }
    }

    /**
     * @return bool
     */
    public static function isInstalled()
    {
        return is_dir(self::getInstallPath());
    }

    /**
     * @param string $language
     * @return null|string
     */
    public static function getTranslationFile($language)
    {
        return null;
    }

    /**
     * @return string
     */
    public static function getInstallPath()
    {
        return PIMCORE_PLUGINS_PATH . "/ExportObjectsToStepsRestApi/install";
    }

}
