<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package ExportObjectsToStepsRestApi\Services
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * Factory constructor.
     * @param ApiManager $apiManager
     */
    public function __construct(ApiManager $apiManager)
    {
        $this->apiManager = $apiManager;
    }

    /**
     * @return Product\Factory
     */
    public function product()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Product\Factory($this->apiManager);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
