<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Add\Model\Request;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class LocalizedField
 *
 * @package ExportObjectsToStepsRestApi\Services\Product\Add\Model\Request
 */
class LocalizedField
{
    /**
     * @Serializer\SerializedName("langId")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 2,
     *      max = 2,
     *      minMessage = "LangId must be at least {{ limit }} characters long",
     *      maxMessage = "LangId cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $langId;

    /**
     * @Serializer\SerializedName("title")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "Title must be at least {{ limit }} characters long",
     *      maxMessage = "Title cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $title;

    /**
     * @Serializer\SerializedName("description")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 1000,
     *      minMessage = "Description must be at least {{ limit }} characters long",
     *      maxMessage = "Description cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $description;

    /**
     * @Serializer\SerializedName("shortDescription")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 1000,
     *      minMessage = "ShortDescription must be at least {{ limit }} characters long",
     *      maxMessage = "ShortDescription cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $shortDescription;

    /**
     * @return string
     */
    public function getLangId()
    {
        return $this->langId;
    }

    /**
     * @param string $langId
     * @return LocalizedField
     */
    public function setLangId($langId)
    {
        $this->langId = $langId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return LocalizedField
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return LocalizedField
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return string
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }

    /**
     * @param string $shortDescription
     * @return LocalizedField
     */
    public function setShortDescription($shortDescription)
    {
        $this->shortDescription = $shortDescription;
        return $this;
    }
}
