<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Add\Model\Request;

use ExportObjectsToStepsRestApi\Services\Model\Request\RequestInterface;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("product")
 *
 * @package ExportObjectsToStepsRestApi\Services\Product\Add\Model\Request
 */
class Request implements RequestInterface
{
    /**
     * @Serializer\SerializedName("products")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Services\Product\Add\Model\Request\Item>")
     *
     * @Assert\NotNull()
     * @Assert\Valid
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var Item[]|ArrayCollection
     */
    protected $items;

    public function __construct()
    {
        $this->items = new ArrayCollection();
    }

    /**
     * @return Item[]|ArrayCollection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param Item $item
     */
    public function addItem(Item $item)
    {
        $this->items[] = $item;
    }

    public function getRequest()
    {
        return $this;
    }

    public function getResponseType()
    {
        return 'ExportObjectsToStepsRestApi\Services\Product\Add\Model\Response\Response';
    }
}
