<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Delete;

use ExportObjectsToStepsRestApi\Client\Manager;
use ExportObjectsToStepsRestApi\Database\ProductRegister;
use ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue\Queue;
use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\Product;

/**
 * Class Handler
 * @package ExportObjectsToStepsRestApi\Services\Product\Delete
 */
class Handler
{
    /**
     * @var Queue
     */
    private $requestQueue;

    /**
     * @var Manager
     */
    private $clientManager;

    /**
     * @var ApplicationLogger
     */
    private $logger;

    /**
     * @var ProductRegister
     */
    private $productRegisterRepo;

    /**
     * Handler constructor.
     * @param Queue $requestQueue
     * @param Manager $clientManager
     * @param ApplicationLogger $logger
     * @param ProductRegister $productRegisterRepo
     */
    public function __construct(Queue $requestQueue, Manager $clientManager, ApplicationLogger $logger, ProductRegister $productRegisterRepo)
    {
        $this->requestQueue = $requestQueue;
        $this->clientManager = $clientManager;
        $this->logger = $logger;
        $this->productRegisterRepo = $productRegisterRepo;
    }

    /**
     * @param Product $object
     */
    public function init(Product $object)
    {
        foreach ($this->clientManager->active() as $client) {

            if (!$this->productRegisterRepo->findByClientAndObjectId($client->getId(), $object->getId())) {
                continue;
            }

            $this->logger->info(sprintf('Object "%s" (ID %d) added to delete request', $object->getKey(), $object->getId()));

            $service = $this->clientManager->service($client, 'Objects::Delete');
            // Replace {productId} placeholder in URL
            $service->replaceUrl('{productId}', $object->getId());

            $this->requestQueue->addClientRequest($client, $service, $object);
        }

        $this->requestQueue->execute();
    }
}
