<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Delete\Model\Response\Error;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @package ExportObjectsToStepsRestApi\Services\Product\Delete\Model\Response\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     *
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Services\Product\Delete\Model\Response\Error\Error>")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    public function __construct()
    {
        $this->errors = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Response
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     * @return Response
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return Response
     */
    public function addError(Error $error)
    {
        $this->errors->add($error);
        return $this;
    }
}
