<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue;

use ExportObjectsToStepsRestApi\Config\Client;
use ExportObjectsToStepsRestApi\Config\Service;
use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use Pimcore\Model\Object\Product;

/**
 * Class Factory
 * @package ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var ApiManager;
     */
    private $apiManager;

    /**
     * Factory constructor.
     * @param ApiManager $apiManager
     */
    public function __construct(ApiManager $apiManager)
    {
        $this->apiManager = $apiManager;
    }

    /**
     * @param Client $client
     * @param Service $service
     * @param Product $product
     * @return Item
     */
    public function item(Client $client, Service $service, Product $product)
    {
        return new Item($client, $service, $product);
    }

    /**
     * @return Queue
     */
    public function queue()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Queue($this, $this->sender());
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Sender
     */
    public function sender()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Sender(
                $this->apiManager->logger(), $this->apiManager->serializer(), $this->apiManager->webservice()->client(), $this->apiManager->database()->productRegister()
            );
        }
        return $this->facSetter[__FUNCTION__];
    }
}
