<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue;

use ExportObjectsToStepsRestApi\Config\Client;
use ExportObjectsToStepsRestApi\Config\Service;
use Pimcore\Model\Object\Product;

/**
 * Class Item
 * @package ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue
 */
class Item
{
    /**
     * @var Client
     */
    private $client;

    /**
     * @var Service
     */
    private $service;

    /**
     * @var Product
     */
    private $product;

    /**
     * Item constructor.
     * @param Client $client
     * @param Service $service
     * @param Product $product
     */
    public function __construct(Client $client, Service $service, Product $product)
    {
        $this->client = $client;
        $this->service = $service;
        $this->product = $product;
    }

    /**
     * @return Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @return Service
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * @return Product
     */
    public function getProduct()
    {
        return $this->product;
    }
}
