<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue;

use ExportObjectsToStepsRestApi\Config\Client;
use ExportObjectsToStepsRestApi\Config\Service;
use Pimcore\Model\Object\Product;

/**
 * Class Queue
 * @package ExportObjectsToStepsRestApi\Services\Product\Delete\RequestQueue
 */
class Queue
{

    /**
     * @var Item[]
     */
    private $items = [];

    /**
     * @var Factory
     */
    private $requestQueueFactory;

    /**
     * @var Sender
     */
    private $sender;

    /**
     * Queue constructor.
     * @param Factory $requestQueueFactory
     * @param Sender $sender
     */
    public function __construct(Factory $requestQueueFactory, Sender $sender)
    {
        $this->requestQueueFactory = $requestQueueFactory;
        $this->sender = $sender;
    }

    /**
     * @param Client $client
     * @param Service $service
     * @param Product $product
     */
    public function addClientRequest(Client $client, Service $service, Product $product)
    {
        $this->items[] = $this->requestQueueFactory->item($client, $service, $product);
    }

    /**
     * @return bool
     */
    public function hasItems()
    {
        return count($this->items) > 0;
    }

    /**
     * Iterate on queue an send requests
     */
    public function execute()
    {
        if ($this->hasItems()) {
            foreach($this->items as $item) {
                $this->sender->send($item->getClient(), $item->getService(), $item->getProduct());
            }
        }
    }
}
