<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package ExportObjectsToStepsRestApi\Services\Product
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * Factory constructor.
     * @param ApiManager $apiManager
     */
    public function __construct(ApiManager $apiManager)
    {
        $this->apiManager = $apiManager;
    }

    /**
     * @return Update\Factory
     */
    public function update()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Update\Factory($this->apiManager);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Add\Factory
     */
    public function add()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Add\Factory($this->apiManager);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Delete\Factory
     */
    public function delete()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete\Factory($this->apiManager);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
