<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Update\Model;

/**
 * Class Factory
 * @package ExportObjectsToStepsRestApi\Services\Product\Update\Model
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @return Request\Factory
     */
    public function request()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Response\Factory
     */
    public function response()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Response\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}