<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Update\Model\Request;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package ExportObjectsToStepsRestApi\Services\Product\Update\Model\Request
 */
class Factory
{
    /**
     * @return Request
     */
    public function request()
    {
        return new Request();
    }

    /**
     * @return Item
     */
    public function item()
    {
        return new Item();
    }

    /**
     * @return LocalizedField
     */
    public function localizedField()
    {
        return new LocalizedField();
    }
}
