<?php

/**
 * ExportObjectsToStepsRestApi
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Update\Model\Request;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @package ExportObjectsToStepsRestApi\Services\Product\Update\Model\Request
 */
class Item
{
    /**
     * @Serializer\SerializedName("productId")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "ProductId must be at least {{ limit }} characters long",
     *      maxMessage = "ProductId cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $productId;

    /**
     * @Serializer\SerializedName("erpId")
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "ProductId must be at least {{ limit }} characters long",
     *      maxMessage = "ProductId cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $erpId = '';

    /**
     * @Serializer\SerializedName("localizedFields")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Services\Product\Update\Model\Request\LocalizedField>")
     *
     * @Assert\NotNull()
     * @Assert\Valid
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var LocalizedField[]|ArrayCollection
     */
    private $localizedFields;

    /**
     * @Serializer\SerializedName("brandName")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "BrandName must be at least {{ limit }} characters long",
     *      maxMessage = "BrandName cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $brandName;

    /**
     * @Serializer\SerializedName("categoryName")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "CategoryName must be at least {{ limit }} characters long",
     *      maxMessage = "CategoryName cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $categoryName;

    /**
     * @Serializer\SerializedName("price")
     * @Serializer\Type("double")
     *
     * @Assert\NotBlank()
     * @Assert\GreaterThanOrEqual(0.00)
     *
     * @var float
     */
    private $price;

    /**
     * @Serializer\SerializedName("vat")
     * @Serializer\Type("double")
     *
     * @Assert\NotBlank()
     * @Assert\GreaterThanOrEqual(0.00)
     *
     * @var float
     */
    private $vat;

    /**
     * @Serializer\SerializedName("published")
     * @Serializer\Type("boolean")
     *
     * @var bool
     */
    private $published = true;

    public function __construct()
    {
        $this->localizedFields = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }

    /**
     * @return string
     */
    public function getErpId()
    {
        return $this->erpId;
    }

    /**
     * @param string $erpId
     * @return Item
     */
    public function setErpId($erpId)
    {
        $this->erpId = $erpId;
        return $this;
    }

    /**
     * @param string $productId
     * @return Item
     */
    public function setProductId($productId)
    {
        $this->productId = $productId;
        return $this;
    }

    /**
     * @return LocalizedField[]|ArrayCollection
     */
    public function getLocalizedFields()
    {
        return $this->localizedFields;
    }

    /**
     * @param LocalizedField $localizedField
     */
    public function addLocalizedField(LocalizedField $localizedField)
    {
        $this->localizedFields[] = $localizedField;
    }

    /**
     * @return string
     */
    public function getBrandName()
    {
        return $this->brandName;
    }

    /**
     * @param string $brandName
     * @return Item
     */
    public function setBrandName($brandName)
    {
        $this->brandName = $brandName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCategoryName()
    {
        return $this->categoryName;
    }

    /**
     * @param string $categoryName
     * @return Item
     */
    public function setCategoryName($categoryName)
    {
        $this->categoryName = $categoryName;
        return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return Item
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return float
     */
    public function getVat()
    {
        return $this->vat;
    }

    /**
     * @param float $vat
     * @return Item
     */
    public function setVat($vat)
    {
        $this->vat = $vat;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPublished()
    {
        return $this->published;
    }

    /**
     * @param bool $published
     * @return Item
     */
    public function setPublished($published)
    {
        $this->published = $published;
        return $this;
    }
}
