<?php

/**
 * steps-rest-ws
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Services\Product\Update\Model\Response;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Errors
 *
 * @package ExportObjectsToStepsRestApi\Services\Product\Update\Model\Response
 */
class Errors
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<ExportObjectsToStepsRestApi\Services\Product\Update\Model\Response\Error>")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @Serializer\Exclude
     * @var array
     */
    private $statusMessages;

    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Forbidden',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = (int)$status;
        if (isset($this->statusMessages[$status])) {
            $this->message = $this->statusMessages[$status];
        } else {
            $this->message = 'Not Found';
        }
    }

    /**
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * count + 1
     */
    public function addCount()
    {
        $this->count++;
    }

    /**
     * count - 1
     */
    public function removeCount()
    {
        $this->count--;
    }

    /**
     * @param Error $error
     * @return Errors
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;
        $this->addCount();
        return $this;
    }

    /**
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->errors->removeElement($error);
        $this->removeCount();
    }

    /**
     * Get Errors
     *
     * @return Error[]|ArrayCollection
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $trackId
     * @return Errors
     */
    public function setTrackId($trackId)
    {
        $this->trackId = (string)$trackId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $code
     * @return Errors
     */
    public function setCode($code)
    {
        $this->code = (string)$code;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
}
