<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjectsToStepsRestApi\Webservice;

use ExportObjectsToStepsRestApi\Api\Manager as ApiManager;
use ExportObjectsToStepsRestApi\Services\Model\Request\RequestInterface;
use ExportObjectsToStepsRestApi\Services\Model\Response\ResponseInterface;
use ExportObjectsToStepsRestApi\Config\Client as ClientConfig;
use ExportObjectsToStepsRestApi\Config\Service as ServiceConfig;
use Guzzle\Http\Exception\RequestException as WebserviceRequestException;

/**
 * Webservice-Request
 *
 * @package ExportObjectsToStepsRestApi\Webservice
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Request
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param RequestInterface $request
     * @param ClientConfig     $client
     * @param ServiceConfig    $service
     *
     * @return ResponseInterface
     * @throws \Exception
     */
    public function send(RequestInterface $request, ClientConfig $client, ServiceConfig $service)
    {
        // Prepare request
        $options = array(
            'headers' => array(
                'X-username' => $client->getApiUserName(),
                'X-api-key' => $client->getApiKey(),
                'X-api-version' => $service->getApiVersion(),
            ),
            'body' => $this->apiM->serializer()->serialize($request->getRequest(), $service->getFormat())
        );

        $this->apiM->logger()->info(sprintf('Object export: sending request to client "%s" url %s', $client->getId(), $service->getUrl()));
        $this->apiM->logger()->debug($options['body']);

        // Send request
        try {
            $webserviceResponse = $this->apiM->webservice()->client()->request($service->getMethod(), $service->getUrl(), $options);
        } catch (WebserviceRequestException $exception) {
            // Received an error response
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getRequest()->getResponse());
        } catch (\GuzzleHttp\Exception\ClientException $exception) {
            // Received an error response
            return $this->apiM->webservice()->response()->receive($client, $service, $request, $exception->getResponse());
        }

        // Received response
        return $this->apiM->webservice()->response()->receive($client, $service, $request, $webserviceResponse);
    }
}
