<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Client;

use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Api\Manager as ApiManager;
use ExportObjects\Client\Manager;
use ExportObjects\Config\Client;
use ExportObjects\Config\PluginConfig;
use ExportObjects\Config\Service;

/**
 * Class TestManager
 *
 * @package Tests\ExportObjects\Client
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * setUp
     */
    public function setUp()
    {

        $pluginConfig = new PluginConfig();

        $clientCollection = new ArrayCollection();


        $client = new Client();
        $client->setId(42);
        $client->setActive(true);
        $clientCollection->add($client);

        $client = new Client();
        $client->setId(56);
        $client->setActive(false);
        $clientCollection->add($client);


        $serviceCollection = new ArrayCollection();

        $service = new Service();
        $service->setName('updateNameXml');
        $service->setUrl('http://localhost/update.xml');
        $serviceCollection->add($service);

        $clientCollection->first()->setServices($serviceCollection);


        $pluginConfig->setClients($clientCollection);


        $this->apiManager = $this
            ->getMockBuilder('ExportObjects\Api\Manager')
            ->getMock();

        $this->apiManager
            ->method('pluginConfig')
            ->will($this->returnValue($pluginConfig));
    }

    /**
     * testManagerActive
     */
    public function testManagerActive()
    {

        $clientManager = new Manager($this->apiManager);

        $clients = $clientManager->active();
        $this->assertCount(1, $clients);
        $this->assertEquals(42, $clients[0]->getId());
    }

    /**
     * testManagerAllClients
     */
    public function testManagerAllClients()
    {

        $clientManager = new Manager($this->apiManager);

        $clients = $clientManager->configured();

        $this->assertCount(2, $clients);

        $this->assertEquals(42, $clients[0]->getId());
        $this->assertEquals(56, $clients[1]->getId());
    }

    /**
     * testManagerServices
     *
     * @throws \ExportObjects\Config\InvalidConfigException
     */
    public function testManagerServices()
    {

        $clientManager = new Manager($this->apiManager);

        $this->assertInstanceOf('ExportObjects\Config\Service', $clientManager->service($clientManager->active(42)->first(), 'updateNameXml'));
    }


    /**
     * testManagerServicesException
     *
     * @throws \ExportObjects\Config\InvalidConfigException
     *
     * @expectedException \ExportObjects\Config\InvalidConfigException
     */
    public function testManagerServicesException()
    {

        $clientManager = new Manager($this->apiManager);

        $clientManager->service($clientManager->active(42)->first(), 'updateNameNotValid');
    }
}
