<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config;

use JMS\Serializer\SerializerBuilder;
use ExportObjects\Config\Client;
use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Config\Service;
use ExportObjects\Config\Units;

/**
 * Class TestClient
 *
 * @package Tests\ExportObjects\Config
 */
class ClientTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Active":true,"Id":"id","Services":[{"Name":"updateNameXml","Url":"http:\/\/localhost\/update.xml"}],"Units":{}}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $client = new Client();

        $client->setId('id');
        $client->setActive(true);

        $serviceCollection = new ArrayCollection();

        $service = new Service();
        $service->setName('updateNameXml');
        $service->setUrl('http://localhost/update.xml');
        $serviceCollection->add($service);

        $client->setServices($serviceCollection);

        $units = new Units();

        $client->setUnits($units);

        $this->assertEquals($this->jsonString, $this->serializer->serialize($client, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        /**
         * @var Client $client
         */
        $client = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Client', 'json');

        $this->assertEquals('id', $client->getId());
        $this->assertEquals(true, $client->isActive());
        $this->assertInstanceOf('ExportObjects\Config\Service', $client->getServices()->first());
        $this->assertInstanceOf('ExportObjects\Config\Units', $client->getUnits());
    }
}
