<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config\Objects;

use JMS\Serializer\SerializerBuilder;
use ExportObjects\Config\Objects\Object as ConfigObject;
use ExportObjects\Config\Objects\Document;
use ExportObjects\Config\Objects\Property;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class TestObject
 *
 * @package Tests\ExportObjects\Config\Objects
 */
class ObjectTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Class":"class","Document":{"Language":"de","Prefix":"pref","Ranking":56,"Text":"random text","Title":"random title","Url":"http:\/\/localhost"},"Prefix":"random prefix","Property":[{"Disabled":false,"Format":"%s","Mapper":"format"}]}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $object = new ConfigObject();

        $object->setClass('class');


        $document = new Document();
        $document
            ->setUrl('http://localhost')
            ->setLanguage('de')
            ->setPrefix('pref')
            ->setRanking(56)
            ->setText('random text')
            ->setTitle('random title');
        $object->setDocument($document);

        $object->setPrefix('random prefix');

        $property = new Property();
        $propertyCollection = new ArrayCollection();
        $propertyCollection->add($property);
        $object->setProperties($propertyCollection);


        $this->assertEquals($this->jsonString, $this->serializer->serialize($object, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        /**
         * @var ConfigObject $object
         */
        $object = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Objects\Object', 'json');

        $this->assertEquals('class', $object->getClass());
        $this->assertInstanceOf('ExportObjects\Config\Objects\Document', $object->getDocument());
        $this->assertEquals('random prefix', $object->getPrefix());
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $object->getProperties());
    }
}
