<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config\Objects;

use JMS\Serializer\SerializerBuilder;
use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Config\Objects\Property;

/**
 * Class TestProperty
 *
 * @package Tests\ExportObjects\Config\Objects
 */
class PropertyTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"BaseUnit":"kg","Disabled":false,"Format":"format","Id":"objectId","Label":"label","LabelId":"labelId","Mapper":"mapper","Unit":"g","UnitValue":"unit value","Value":[]}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testSerialize()
    {

        $property = new Property();

        $values = new ArrayCollection();

        $property
            ->setBaseUnit('kg')
            ->setDisabled(false)
            ->setFormat('format')
            ->setId('objectId')
            ->setLabel('label')
            ->setLabelId('labelId')
            ->setMapper('mapper')
            ->setUnit('g')
            ->setUnitValue('unit value')
            ->setValues($values);

        $this->assertEquals($this->jsonString, $this->serializer->serialize($property, 'json'));
    }

    public function testDeserialize()
    {

        /**
         * @var Property $property
         */
        $property = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Objects\Property', 'json');

        $this->assertEquals('kg', $property->getBaseUnit());
        $this->assertEquals(false, $property->isDisabled());
        $this->assertEquals('format', $property->getFormat());
        $this->assertEquals('objectId', $property->getId());
        $this->assertEquals('label', $property->getLabel());
        $this->assertEquals('labelId', $property->getLabelId());
        $this->assertEquals('mapper', $property->getMapper());
        $this->assertEquals('g', $property->getUnit());
        $this->assertEquals('unit value', $property->getUnitValue());
        $this->assertInstanceOf('Doctrine\Common\Collections\ArrayCollection', $property->getValues());
    }
}
