<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config;

use JMS\Serializer\SerializerBuilder;
use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Config\Objects;

class ObjectsTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Object":[{},{}]}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testSerialize()
    {

        $objects = new Objects();

        $objectCollection = new ArrayCollection();
        $objectCollection->add(new Objects\Object());
        $objectCollection->add(new Objects\Object());

        $objects->setObject($objectCollection);

        $this->assertEquals($this->jsonString, $this->serializer->serialize($objects, 'json'));
    }

    public function testDeserialize()
    {

        /**
         * @var Objects $objects
         */
        $objects = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Objects', 'json');

        $this->assertInstanceOf('ExportObjects\Config\Objects', $objects);
        $this->assertInstanceOf('ExportObjects\Config\Objects\Object', $objects->getObject()->first());
    }
}
