<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config\Objects;

use JMS\Serializer\SerializerBuilder;
use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Config\Objects;
use ExportObjects\Config\PluginConfig;
use ExportObjects\Config\Client;

class PluginConfigTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Clients":[{}],"Objects":{}}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    public function testSerialize()
    {

        $pluginConfig = new PluginConfig();

        $clientCollection = new ArrayCollection();
        $clientCollection->add(new Client());
        $pluginConfig->setClients($clientCollection);


        $pluginConfig->setObjects(new Objects());

        $this->assertEquals($this->jsonString, $this->serializer->serialize($pluginConfig, 'json'));
    }

    public function testDeserialize()
    {

        /**
         * @var PluginConfig $pluginConfig
         */
        $pluginConfig = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\PluginConfig', 'json');

        $this->assertInstanceOf('ExportObjects\Config\Client', $pluginConfig->getClients()->first());
        $this->assertInstanceOf('ExportObjects\Config\Objects', $pluginConfig->getObjects());
    }
}
