<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\EventListener;

use Doctrine\Common\Collections\ArrayCollection;
use ExportObjects\Api\Manager as ApiManager;
use ExportObjects\Config\Objects\Object;
use ExportObjects\Config\Objects\Document;
use ExportObjects\Config\Service;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Response;
use Pimcore\Model\Object\Concrete;
use ExportObjects\Config\Client as ConfigClient;

/**
 * Class UpdateTest
 *
 * @package Tests\ExportObjects\EventListener
 */
class UpdateTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var MockHandler
     */
    private $webserviceHandler;

    /**
     * setUp
     */
    public function setUp()
    {

        // Mock api manager
        $this->apiManager = $this->getMockBuilder('\ExportObjects\Api\Manager')
            ->setMethods(['webservice'])
            ->getMock();

        // Mock webservice manager
        $webserviceManagerMock = $this->getMockBuilder('\ExportObjects\Webservice\Manager')
            ->setConstructorArgs([$this->apiManager])
            ->setMethods(['client'])
            ->getMock();

        // Create a mock
        $this->webserviceHandler = new MockHandler();
        $client = new Client(['handler' => HandlerStack::create($this->webserviceHandler)]);

        // Set mock methods
        $webserviceManagerMock->method('client')->willReturn($client);
        $this->apiManager->method('webservice')->willReturn($webserviceManagerMock);


        $pluginConfigDocument = new Document();

        $pluginConfigObject = new Object();
        $pluginConfigObject->setClass('Pimcore\Model\Object\Concrete');
        $pluginConfigObject->setDocument($pluginConfigDocument);
        $pluginConfigObject->setPrefix('product');

        $objectCollection = new ArrayCollection();
        $objectCollection->add($pluginConfigObject);

        $this->apiManager->pluginConfig()->getObjects()->setObject($objectCollection);

        $clientCollection = new ArrayCollection();

        $client = new ConfigClient();
        $client->setActive(true);

        $serviceCollection = new ArrayCollection();

        $service = new Service();
        $service->setName('Objects::Update');
        $service->setUrl('http://localhost/update.json');
        $serviceCollection->add($service);

        $service = new Service();
        $service->setName('Objects::Delete');
        $service->setUrl('http://localhost/delete.json');
        $serviceCollection->add($service);

        $client->setServices($serviceCollection);

        $clientCollection->add($client);

        $this->apiManager->pluginConfig()->setClients($clientCollection);
    }

    /**
     * Add response to mocked webservice client
     *
     * @param int    $statusCode
     * @param array  $headers
     * @param string $body
     *
     * @throws \Exception
     */
    protected function webserviceAddResponse($statusCode = 200, $headers = [], $body = null)
    {

        if (null === $this->webserviceHandler) {
            throw new \Exception('Cannot set webservice response: No webservice client initialized. Create webserviceBuildApiM first!');
        }
        $this->webserviceHandler->append(new Response($statusCode, $headers, $body));
    }

    public function testUpdate()
    {

        $concrete = new Concrete();
        $concrete->setPublished(true);

        $this->apiManager->eventListener()->update()->init();
        $this->webserviceAddResponse(200, ['Content-Type' => 'application/json'], json_encode([]));
        $event = new \Zend_EventManager_Event('object.postUpdate', $concrete);
        $this->apiManager->eventListener()->update()->update($event);
    }

    /**
     * testNotSubscribed
     *
     * @throws \Exception
     */
    public function testNotSubscribed()
    {

        $this->apiManager->eventListener()->update()->update(new \Zend_EventManager_Event('object.postUpdate'));
    }
}
