<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Webservice;

use ExportObjects\Api\Manager as ApiManager;
use ExportObjects\Webservice\Manager;

/**
 * Class ManagerTest
 *
 * @package Tests\ExportObjects\Webservice
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    public function testManager()
    {

        $manager = new Manager(new ApiManager());

        $this->assertInstanceOf('GuzzleHttp\Client', $manager->client());
        $this->assertInstanceOf('ExportObjects\Webservice\Request', $manager->request());
        $this->assertInstanceOf('ExportObjects\Webservice\Response', $manager->response());
    }
}
