<?php

/**
 * Steps Box
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Tests;

use ReflectionClass;
use ReflectionException;
use Exception;

class PrivacyHelper
{
    /**
     * @var object|object
     */
    protected $object;

    /**
     * @var ReflectionClass
     */
    protected $reflectionObject;

    /**
     * @param object $object
     */
    public function __construct($object)
    {
        $this->object = $object;
        $this->reflectionObject = new ReflectionClass($this->object);
    }

    /**
     * @param string $name
     * @param array $arguments
     *
     * @return mixed
     */
    public function __call($name, $arguments)
    {
        $method = $this->getReflectionMethod($name);
        $return = $method->invokeArgs($this->object, $arguments);

        return $return;
    }

    /**
     * @param string $name
     *
     * @return \ReflectionMethod
     * @throws \Exception
     */
    protected function getReflectionMethod($name)
    {
        $method = null;
        try {
            $method = $this->reflectionObject->getMethod($name);
        } catch (ReflectionException $e) {
            throw new Exception(sprintf('Unknown method "%s" for class "%s"!', $name, get_class($this->object)));
        }
        $method->setAccessible(true);

        return $method;
    }

    /**
     * @param string $name
     *
     * @return mixed
     */
    public function __get($name)
    {
        $property = $this->getReflectionProperty($name);
        $value = $property->getValue($this->object);

        return $value;
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function __set($name, $value)
    {
        $property = $this->getReflectionProperty($name);
        $property->setValue($this->object, $value);
    }

    /**
     * @param string $name
     *
     * @return \ReflectionProperty
     * @throws \Exception
     */
    protected function getReflectionProperty($name)
    {
        $property = null;
        try {
            $property = $this->reflectionObject->getProperty($name);
        } catch (ReflectionException $e) {
            throw new Exception(sprintf('Unknown property "%s" for class "%s"!', $name, get_class($this->object)));
        }
        $property->setAccessible(true);

        return $property;
    }
}