<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Config;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Client
 *
 * @package ExportObjects\Config
 * @author  Oliver Friedrich <of@life-style.de>
 *
 * @Serializer\XmlRoot("Client")
 */
class Client
{
    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("boolean")
     * @var boolean
     */
    private $active;
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;
    /**
     * @Serializer\SerializedName("Services")
     * @Serializer\Type("ArrayCollection<ExportObjects\Config\Service>")
     * @Serializer\XmlList(entry="Service")
     * @var ArrayCollection
     */
    private $services;

    /**
     * @Serializer\SerializedName("Units")
     * @Serializer\Type("ExportObjects\Config\Units")
     * @var Units
     */
    private $units;

    /**
     * @return string
     */
    public function getId()
    {

        return $this->id;
    }

    /**
     * @param string $id
     *
     * @return Client
     */
    public function setId($id)
    {

        $this->id = $id;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {

        return $this->active;
    }

    /**
     * @param boolean $active
     *
     * @return Client
     */
    public function setActive($active)
    {

        $this->active = $active;

        return $this;
    }

    /**
     * @return ArrayCollection<Service>
     */
    public function getServices()
    {

        return $this->services;
    }

    /**
     * @param ArrayCollection<Service> $services
     *
     * @return Client
     */
    public function setServices($services)
    {

        $this->services = $services;

        return $this;
    }

    /**
     * @return Units
     */
    public function getUnits()
    {

        return $this->units;
    }

    /**
     * @param Units $units
     *
     * @return Client
     */
    public function setUnits($units)
    {

        $this->units = $units;

        return $this;
    }
}
