<?php
/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\ValueMapper;

use ExportObjects\Mapper\Mapper as ObjectMapper;
use ExportObjects\Config\Objects\Property as ConfigProperty;

/**
 * Interface MapperInterface
 *
 * @package ExportObjects\ValueMapper
 * @author Oliver Friedrich <of@life-style.de>
 */
interface MapperInterface
{
    /**
     * Get list of valid units
     *
     * @return array
     */
    public function getValidUnits();

    /**
     * Map value
     *
     * @param ObjectMapper   $objectMapper
     * @param ConfigProperty $property
     * @param string         $language
     *
     * @return mixed
     */
    public function map(ObjectMapper $objectMapper, ConfigProperty $property, $language);
}
