<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Worker;

use ExportObjects\Api\Manager as ApiManager;
use Pimcore\Model\Object\Concrete;
use Swoox\Api\Model\Request\Delete\Swoox\Request;

/**
 * Delete Worker
 *
 * @package ExportObjects\Worker
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Delete
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {

        $this->apiM = $apiM;
    }

    /**
     * Run export
     *
     * @param Concrete $object
     */
    public function run(Concrete $object)
    {

        // Prepare request
        $modelRequest = $this->apiM->model()->request()->delete()->swoox();

        // Prepare data
        $this->delete($modelRequest, $object);

        $this->apiM->logger()->debug(sprintf('Object "%s" (ID: %d) added to delete request', $object->getKey(), $object->getId()));

        // Send request
        foreach ($this->apiM->clients()->active() as $client) {
            $service = $this->apiM->clients()->service($client, 'Objects::Delete');
            $this->apiM->webservice()->request()->send($modelRequest, $client, $service);
        }
    }

    /**
     * @param Request  $request
     * @param Concrete $object
     */
    private function delete(Request $request, Concrete $object)
    {

        #$mapper = $this->apiM->mapper()->object($object);

        #$exportDocumentConfig = $this->apiM->getExportConfig()->getDocument();
        #$uniqueKey = $exportDocumentConfig->getUniqueKey();
        #$uniqueValue = $mapper->getValue($uniqueKey);

        $item = $this->apiM->model()->request()->delete()->item();
        $item->setDocumentUniqueKey($object->getId());

        $request->addItem($item);
    }
}
