<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace ExportObjects\Tests;

require_once 'TestBase.php';

/**
 * Class EventListenerTest
 *
 * @package ExportObjects\Tests
 */
class EventListenerTest extends TestBase
{



    /**
     *
     */
    public function testNotSubscibed()
    {
        $this->markTestSkipped();
        $this->apiM()->eventListener()->update()->update(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->unpublish(new \Zend_EventManager_Event('object.postUpdate'));
        $this->apiM()->eventListener()->delete()->delete(new \Zend_EventManager_Event('object.postDelete'));
    }

    /**
     * @throws \Exception
     */
    public function testUnpublish()
    {$this->markTestSkipped();
        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->delete()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getDatenblattUnpublished());
        $apiM->eventListener()->delete()->unpublish($event);
    }

    /**
     * @throws \Exception
     */
    public function testUpdate()
    {
        $this->markTestSkipped();
        $apiM = $this->webserviceBuildApiM();
        $apiM->eventListener()->update()->init();
        $this->webserviceAddResponse(200, array('Content-Type' => 'application/json'), json_encode(array()));
        $event = new \Zend_EventManager_Event('object.postUpdate', $this->getDatenblattUnpublished());
        $apiM->eventListener()->update()->update($event);
    }
}
