<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Api;

use ExportObjects\Client\Manager as ClientManager;
use ExportObjects\Config\PluginConfig;
use ExportObjects\EventListener\Manager as EventListenerManager;
use ExportObjects\Mapper\Factory as MapperFactory;
use ExportObjects\Pimcore\Manager as PimcoreManager;
use ExportObjects\Translate\Manager as TranslateManager;
use ExportObjects\ValueMapper\Manager as ValueMapperManager;
use ExportObjects\Webservice\Manager as WebserviceManager;
use ExportObjects\Worker\Manager as WorkerManager;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;
use Pimcore\Log\ApplicationLogger as Logger;
use Swoox\Api\Api\Manager as ApiModelManager;

/**
 * Api-Manager
 *
 * @package ExportObjects\Api
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Manager
{

    /**
     * @var \ExportObjects\Config\Objects\Object
     */
    private $exportConfig = null;
    /**
     *
     * @var array
     */
    private $factory = array();

    /**
     * @return ClientManager
     */
    public function clients()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ClientManager($this));
    }

    /**
     * @return EventListenerManager
     */
    public function eventListener()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new EventListenerManager($this));
    }

    /**
     * @return \ExportObjects\Config\Objects\Object
     */
    public function getExportConfig()
    {

        return $this->exportConfig;
    }

    /**
     * @param \ExportObjects\Config\Objects\Object $exportConfig
     */
    public function setExportConfig($exportConfig)
    {

        $this->exportConfig = $exportConfig;
    }

    /**
     * @return Logger
     */
    public function logger()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = Logger::getInstance("ExportObjects", true));
    }

    /**
     * @return MapperFactory
     */
    public function mapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MapperFactory($this));
    }

    /**
     * @return \Swoox\Api\Model\Manager
     */
    public function model()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = (new ApiModelManager())->model());
    }

    /**
     * @return PimcoreManager
     */
    public function pimcore()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PimcoreManager($this));
    }

    /**
     * @return PluginConfig
     */
    public function pluginConfig()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = $this->serializer()->deserialize(file_get_contents(__DIR__ . '/../../../config.xml'), 'ExportObjects\Config\PluginConfig',
            'xml'));
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }

    /**
     * @return TranslateManager
     */
    public function translate()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new TranslateManager($this));
    }

    /**
     * @return ValueMapperManager
     */
    public function valuemapper()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ValueMapperManager($this));
    }

    /**
     * @return WebserviceManager
     */
    public function webservice()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WebserviceManager($this));
    }

    /**
     * @return WorkerManager
     */
    public function worker()
    {

        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new WorkerManager($this));
    }
}
