<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Config\Objects;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

class Property
{
    /**
     * BaseUnit - base unit for mapper [optional]
     *
     * @Serializer\SerializedName("BaseUnit")
     * @Serializer\Type("string")
     * @var string
     */
    private $baseUnit;
    /**
     * Skip - set to true, to ignore property
     *
     * @Serializer\SerializedName("Disabled")
     * @Serializer\Type("boolean")
     * @var bool
     */
    private $disabled = false;
    /**
     * Format - output format for sprintf [optional]
     *
     * @Serializer\SerializedName("Format")
     * @Serializer\Type("string")
     * @var string
     */
    private $format = '%s';
    /**
     * Id - property name in pimcore object
     *
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;
    /**
     * Label - label name for translation
     *
     * @Serializer\SerializedName("Label")
     * @Serializer\Type("string")
     * @var string
     */
    private $label;
    /**
     * Label - label-id in export xml [optional]
     *
     * @Serializer\SerializedName("LabelId")
     * @Serializer\Type("string")
     * @var string
     */
    private $labelId;
    /**
     * Mapper - value mapper [optional]
     *
     * @Serializer\SerializedName("Mapper")
     * @Serializer\Type("string")
     * @var string
     */
    private $mapper = 'format';
    /**
     * Unit - unit property name in object-object for mapper [optional]
     *
     * @Serializer\SerializedName("Unit")
     * @Serializer\Type("string")
     * @var string
     */
    private $unit;
    /**
     * Unit - unit value for mapper [optional]
     *
     * Use this as alternative to $unit, if no unit-option-select is configured
     *
     * @Serializer\SerializedName("UnitValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $unitValue;
    /**
     * Values - list of value property names in object-object passed to sprintf
     *
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(inline=true, entry="Value")
     * @var ArrayCollection
     */
    private $values;

    /**
     * @return string
     */
    public function getId()
    {

        return $this->id;
    }

    /**
     * @param string $id
     *
     * @return Property
     */
    public function setId($id)
    {

        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabel()
    {

        return $this->label ? $this->label : lcfirst(preg_replace('/^object/', '', $this->getId()));
    }

    /**
     * @param string $label
     *
     * @return Property
     */
    public function setLabel($label)
    {

        $this->label = $label;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelId()
    {

        return $this->labelId ? $this->labelId : $this->getLabel();
    }

    /**
     * @param string $labelId
     *
     * @return Property
     */
    public function setLabelId($labelId)
    {

        $this->labelId = $labelId;

        return $this;
    }

    /**
     * @return string
     */
    public function getFormat()
    {

        return $this->format;
    }

    /**
     * @param string $format
     *
     * @return Property
     */
    public function setFormat($format)
    {

        $this->format = $format;

        return $this;
    }

    /**
     * @return string
     */
    public function getMapper()
    {

        return $this->mapper;
    }

    /**
     * @param string $mapper
     *
     * @return Property
     */
    public function setMapper($mapper)
    {

        $this->mapper = $mapper;

        return $this;
    }

    /**
     * @return string
     */
    public function getUnit()
    {

        return $this->unit;
    }

    /**
     * @param string $unit
     *
     * @return Property
     */
    public function setUnit($unit)
    {

        $this->unit = $unit;

        return $this;
    }

    /**
     * @return string
     */
    public function getUnitValue()
    {

        return $this->unitValue;
    }

    /**
     * @param string $unitValue
     *
     * @return Property
     */
    public function setUnitValue($unitValue)
    {

        $this->unitValue = $unitValue;

        return $this;
    }

    /**
     * @return string
     */
    public function getBaseUnit()
    {

        return $this->baseUnit;
    }

    /**
     * @param string $baseUnit
     *
     * @return Property
     */
    public function setBaseUnit($baseUnit)
    {

        $this->baseUnit = $baseUnit;

        return $this;
    }

    /**
     * @return ArrayCollection
     */
    public function getValues()
    {

        return $this->values;
    }

    /**
     * @param ArrayCollection $values
     *
     * @return Property
     */
    public function setValues($values)
    {

        $this->values = $values;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDisabled()
    {

        return $this->disabled;
    }

    /**
     * @param boolean $disabled
     *
     * @return Property
     */
    public function setDisabled($disabled)
    {

        $this->disabled = $disabled;

        return $this;
    }

    /**
     * @Serializer\PostDeserialize
     */
    public function updateValues()
    {

        if (null === $this->values || $this->values->isEmpty()) {
            $this->values = new ArrayCollection(array($this->getId()));
        }
    }
}
