<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Mapper;

use ExportObjects\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;
use Pimcore\Model\Object\Fieldcollection\Data\AbstractData as ObjectFieldcollection;

/**
 * Field-Collection-Mapper
 *
 * @package ExportObjects\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class FieldCollection extends Base
{
    /**
     * Plugin api manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var ObjectFieldcollection
     */
    protected $fieldCollection;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM, ObjectFieldcollection $objectFieldcollection)
    {

        $this->apiM = $apiM;
        $this->fieldCollection = $objectFieldcollection;
    }

    /**
     * @return array
     */
    public function getValues()
    {

        $values = array();
        foreach ($this->getObjectProperties() as $property) {
            $method = 'get' . ucfirst($property);
            null !== ($value = $this->getObject()->$method()) ? $values[$property] = $value : null;
        }

        return $values;
    }

    /**
     * @return ObjectFieldcollection
     */
    public function getObject()
    {

        return $this->fieldCollection;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {

        $prefix = $this->apiM->getExportConfig()->getPrefix();

        return (bool) preg_match("/^$prefix/", $property);
    }
}
