<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Mapper;

use ExportObjects\Api\Manager as ApiManager;
use Pimcore\Model\Object\AbstractObject;

/**
 * Mapper for project specific Object "Datenblatt"
 *
 * @package ExportObjects\Mapper
 * @author  Oliver Friedrich <of@life-style.de>
 */
class Mapper extends Object
{
    /**
     * @var object
     */
    private $object;

    /**
     * Mapper constructor.
     *
     * @param ApiManager $apiM
     * @param object     $object
     */
    public function __construct(ApiManager $apiM, $object)
    {

        parent::__construct($apiM);
        $this->object = $object;
    }

    /**
     * @return object
     */
    public function getObject()
    {

        return $this->object;
    }

    /**
     * @param string $property
     *
     * @return boolean
     */
    protected function filterProperties($property)
    {

        $prefix = $this->apiM->getExportConfig()->getPrefix();

        return preg_match("/^$prefix/", $property) || 'localizedfields' == $property;
    }

    /**
     * Map name to name-id
     *
     * @param $name
     *
     * @return string
     */
    public function mapNameId($name)
    {

        return $name;

        return preg_replace('/^object(multi)?/i', '', $name);
    }

}
