<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Api;

use ExportObjects\Api\Manager as ApiManager;
use ExportObjects\Config\Objects\Object;

/**
 * Class TestManager
 *
 * @package Tests\ExportObjects\Api
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->apiManager = new ApiManager();
    }

    /**
     * testApiManager
     */
    public function testApiManager()
    {

        $this->assertInstanceOf('ExportObjects\Client\Manager', $this->apiManager->clients());
        $this->assertInstanceOf('ExportObjects\Config\PluginConfig', $this->apiManager->pluginConfig());
        $this->assertInstanceOf('ExportObjects\EventListener\Manager', $this->apiManager->eventListener());
        $this->assertInstanceOf('ExportObjects\Mapper\Factory', $this->apiManager->mapper());
        $this->assertInstanceOf('Swoox\Api\Model\Manager', $this->apiManager->model());
        $this->assertInstanceOf('ExportObjects\ValueMapper\Manager', $this->apiManager->valuemapper());
        $this->assertInstanceOf('ExportObjects\Pimcore\Manager', $this->apiManager->pimcore());
        $this->assertInstanceOf('ExportObjects\Translate\Manager', $this->apiManager->translate());
        $this->assertInstanceOf('ExportObjects\Webservice\Manager', $this->apiManager->webservice());
        $this->assertInstanceOf('ExportObjects\Worker\Manager', $this->apiManager->worker());
        $this->assertInstanceOf('Pimcore\Log\ApplicationLogger', $this->apiManager->logger());
        $this->assertInstanceOf('JMS\Serializer\Serializer', $this->apiManager->serializer());
    }

    /**
     * testExportConfig
     */
    public function testExportConfig()
    {

        $configObject = new Object();

        $this->apiManager->setExportConfig($configObject);

        $this->assertInstanceOf('ExportObjects\Config\Objects\Object', $this->apiManager->getExportConfig());
    }
}
