<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config\Objects;

use JMS\Serializer\SerializerBuilder;
use ExportObjects\Config\Objects\Document;

/**
 * Class TestDocument
 *
 * @package Tests\ExportObjects\Config\Objects
 */
class DocumentTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var string
     */
    private $jsonString = '{"Language":"de","Prefix":"pref","Ranking":56,"Text":"random text","Title":"random title","Url":"http:\/\/localhost"}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $document = new Document();

        $document
            ->setUrl('http://localhost')
            ->setLanguage('de')
            ->setPrefix('pref')
            ->setRanking(56)
            ->setText('random text')
            ->setTitle('random title');

        $this->assertEquals($this->jsonString, $this->serializer->serialize($document, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        /**
         * @var Document $document
         */
        $document = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Objects\Document', 'json');

        $this->assertEquals('http://localhost', $document->getUrl());
        $this->assertEquals('de', $document->getLanguage());
        $this->assertEquals('pref', $document->getPrefix());
        $this->assertEquals(56, $document->getRanking());
        $this->assertEquals('random text', $document->getText());
        $this->assertEquals('random title', $document->getTitle());
    }
}
