<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\ExportObjects\Config;

use ExportObjects\Config\Service;
use JMS\Serializer\SerializerBuilder;

/**
 * Class ServiceTest
 *
 * @package Tests\ExportObjects\Config
 */
class ServiceTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var string
     */
    private $jsonString = '{"Name":"updateXml","Url":"http:\/\/localhost\/update.xml"}';

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $service = new Service();

        $service->setName('updateXml');
        $service->setUrl('http://localhost/update.xml');

        $this->assertEquals($this->jsonString, $this->serializer->serialize($service, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        /**
         * @var Service $service
         */
        $service = $this->serializer->deserialize($this->jsonString, 'ExportObjects\Config\Service', 'json');

        $this->assertEquals('updateXml', $service->getName());
        $this->assertEquals('http://localhost/update.xml', $service->getUrl());
    }

    /**
     * testFormatXml
     */
    public function testFormatXml()
    {

        $service = new Service();

        $service->setUrl('http://localhost/update.xml');

        $this->assertEquals('xml', $service->getFormat());
    }

    /**
     * testFormatJson
     */
    public function testFormatJson()
    {

        $service = new Service();

        $service->setUrl('http://localhost/update.json');

        $this->assertEquals('json', $service->getFormat());
    }

    /**
     * testGetContentTypeXml
     */
    public function testContentTypeXml()
    {

        $service = new Service();

        $service->setUrl('http://localhost/update.xml');

        $this->assertEquals('text/xml; charset=UTF-8', $service->getContentType());
        $this->assertEquals('text/xml', $service->getAcceptContentType());
    }

    /**
     * testGetContentTypeJson
     */
    public function testContentTypeJson()
    {

        $service = new Service();

        $service->setUrl('http://localhost/update.json');

        $this->assertEquals('application/json; charset=UTF-8', $service->getContentType());
        $this->assertEquals('application/json', $service->getAcceptContentType());
    }

    public function testGetContentTypeNone()
    {

        $service = new Service();

        $service->setUrl('http://localhost/update');

        $this->assertNull($service->getContentType());
        $this->assertEquals('', $service->getAcceptContentType());
    }
}
