<?php

/**
 * PimCore Export Objects Plugin
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace ExportObjects\Tests;

use ExportObjects\Plugin;

/**
 * Test plugin.php
 *
 * @package ExportTranslations
 */
class PluginTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \ExportTranslations\Plugin
     */
    private $plugin;

    public function testInit()
    {$this->markTestSkipped();
        $plugin = new Plugin();
        $plugin->init();
        $isInstalled = Plugin::isInstalled();

        $this->assertFalse(Plugin::needsReloadAfterInstall());
        $this->assertTrue(is_string(Plugin::uninstall()));
        $this->assertFalse(Plugin::isInstalled());
        $this->assertTrue(is_string(Plugin::install()));
        $this->assertTrue(Plugin::isInstalled());
        $this->assertTrue(is_string(Plugin::getInstallPath()));
        $this->assertTrue(file_exists(Plugin::getInstallPath()));
        $this->assertNull(Plugin::getTranslationFile('en'));

        if (!$isInstalled) {
            Plugin::uninstall();
        }
    }

}
