<?php
/**
 * Short description for file
 *
 * Long description for file (if any)...
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace ExportObjects\Tests\ValueMapper;

use ExportObjects\Config\Client;
use ExportObjects\Tests\TestBase;
use ExportObjects\ValueMapper\NumberFormat;
use Pimcore\Model\Object\Datenblatt;

/**
 * Test Value Mappers
 *
 * @package ExportObjects\Tests
 */
class NumberFormatTest extends TestBase
{

    public function testMapDe()
    {
        $this->markTestSkipped();
        $this->mapTest('de', 30.5, '30,5 mm');
    }

    public function testMapEn()
    {
        $this->markTestSkipped();
        $this->mapTest('en', 30.5, '30.5 mm');
    }

    public function testMapEs()
    {
        $this->markTestSkipped();
        $this->mapTest('es', 30.5, '30,5 mm');
    }

    public function testMapFr()
    {
        $this->markTestSkipped();
        $this->mapTest('fr', 30.5, '30,5 mm');
    }

    public function testMapIt()
    {
        $this->markTestSkipped();
        $this->mapTest('it', 30.5, '30,5 mm');
    }

    public function testMapNl()
    {
        $this->markTestSkipped();
        $this->mapTest('nl', 30.5, '30,5 mm');
    }


    public function testMapper()
    {
        $this->markTestSkipped();
        $configProperty = $this->getConfigProperty();

        $this->assertEquals('numberFormat', $configProperty->getMapper());
    }

    private function mapTest($language, $value, $expected)
    {
        $this->markTestSkipped();
        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getConfigProperty();

        $formatter = new NumberFormat($this->apiM(), $client);

        $objectMapper->getObject()->setDatenblattWassersaeule($value);

        $formattedValue = $formatter->map($objectMapper, $configProperty, $language);

        $this->assertEquals($expected, $formattedValue);
    }

    /**
     * @return \ExportObjects\Mapper\Mapper
     */
    private function getObjectMapper()
    {

        $datenblatt = new Datenblatt();
        $datenblatt->setDatenblattDicke(1000);

        return $this->apiM()->mapper()->object($datenblatt);
    }

    /**
     *
     * @return \ExportObjects\Config\Objects\Property
     */
    private function getConfigProperty()
    {

        $xml = <<<'XML'
<?xml version="1.0" encoding="UTF-8"?>
<Property>
    <Id>datenblattWassersaeule</Id>
    <Label>__wassersaeule</Label>
    <Format>%s mm</Format>
    <Mapper>numberFormat</Mapper>
    <UnitValue>mm</UnitValue>
    <BaseUnit>mm</BaseUnit>
</Property>
XML;

        $property = $this->apiM()->serializer()->deserialize($xml, 'ExportObjects\Config\Objects\Property', 'xml');

        return $property;
    }



    /**
     *
     * @return \ExportObjects\Config\Objects\Property
     */
    private function getMultiConfigProperty()
    {

        $xml = <<<'XML'
<?xml version="1.0" encoding="UTF-8"?>
<Property>
    <Id>datenblattInhalt</Id>
    <Format>%s %s</Format>
    <Value>datenblattInhalt</Value>
    <Value>datenblattInhaltEinheit</Value>
</Property>
XML;

        $property = $this->apiM()->serializer()->deserialize($xml, 'ExportObjects\Config\Objects\Property', 'xml');

        return $property;
    }


    public function formatMapperTest($language, array $value, $expected)
    {

        $client = $this->getClient();
        $objectMapper = $this->getObjectMapper();
        $configProperty = $this->getMultiConfigProperty();

        $formatter = new NumberFormat($this->apiM(), $client);

        $objectMapper->getObject()->setDatenblattInhalt($value[0]);
        $objectMapper->getObject()->setDatenblattInhaltEinheit($value[1]);

        $formattedValue = $formatter->map($objectMapper, $configProperty, $language);

        $this->assertEquals($expected, $formattedValue);
    }


    public function testMultiMapEn()
    {
        $this->markTestSkipped();
        $this->formatMapperTest('en', [8.111, 10.45], '8.111 10.45');
    }


    public function testMultiMapDe()
    {
        $this->markTestSkipped();
        $this->formatMapperTest('de', [8.111, 10.45], '8,111 10,45');
    }


    /**
     * @return Client
     */
    private function getClient()
    {

        return $this->apiM()->clients()->configured()->first();
    }
}
